<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 01.02.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Freigegebene Identitäten');
requireLogin();
requireRole(['Bediener', 'Bearbeiter', 'Administrator']);
showSessionAlert();
initializeDatabaseConnection();

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Freigegebene Identitäten</h4>
        <span class="text-secondary">Identitäten</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap"></div>
</div>

<div class="row">
    <div class="col-12 col-md-9 order-2 order-xl-1 grid-margin">
        <div class="card">
            <div class="card-header bg-primary text-white">
                Personen
            </div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT * 
                        FROM Identities
                        WHERE AccessCard IS NOT NULL 
                        AND AccessCard != ''
                        AND OperatorAuthorisation = '1'
                        AND (
                            CURDATE() BETWEEN DATE(IdentityIN) AND DATE(IdentityOUT) 
                            OR CURDATE() = DATE(IdentityIN)
                            OR CURDATE() = DATE(IdentityOUT)
                        )
                        ORDER BY ID DESC;
                    ";

                    $stmt = $pdo->prepare($sql);
                    $stmt->execute();
                    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                    if ($results) {
                        echo '<div class="table-responsive">';
                        echo "<table id='dTableAuthorizedIdentities' class='table table-bordered'>";
                        echo "<thead><tr><th>Karte</th><th>Nachname</th><th>Vorname</th><th>Ausweis-ID</th><th>Mitarbeiterausweis</th><th>Optionen</th></tr></thead>";

                        foreach ($results as $row) {
                            echo "<tr>";
                            echo "<td style='padding: .60rem .85rem;''><span class='btn btn-sm btn-outline-secondary'><i class='btn-icon-prepend mdi mdi-credit-card-outline me-1'></i>{$row['AccessCard']}</span></td>";
                            echo "<td>{$row['Surname']}</td>";
                            echo "<td>{$row['Givenname']}</td>";
                            echo "<td>{$row['LocalIDCard']}</td>";
                            echo "<td>{$row['LocalEmployeeID']}</td>";
                            echo '<td style="padding: .60rem .85rem;"><a href="/identities/authorized-identity?id=' . $row['ID'] . '" class="btn btn-sm btn-inverse-light btn-icon-text" style="margin: 0px;"><i class="mdi mdi-eye"></i> Ansehen</a></td>';
                            echo "</tr>";
                        }

                        echo "</table>";
                        echo '</div>';
                    } else {
                        echo '<div class="alert alert-fill-light mb-0" role="alert">
                                <i class="mdi mdi-eye-off"></i>
                                Derzeit sind im aktuellen Zeitraum keine Personen zur Einsichtnahme freigegeben.
                            </div>
                            ';
                    }
                } catch (PDOException $e) {
                    echo "Datenbankfehler: " . $e->getMessage();
                }
                ?>
            </div>
        </div>
    </div>

    <div class="col-12 col-md-3 order-1 order-xl-2 grid-margin">
        <div class="card">
            <div class="card-header bg-warning text-white">
                Information
            </div>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">Die in dieser Liste aufgeführten Personen wurden ausdrücklich
                    zur Einsichtnahme freigegeben. Dies bedeutet, dass Sie die Berechtigung haben, die relevanten Daten
                    dieser Personen einzusehen. Bitte gehen Sie mit diesen Informationen verantwortungsvoll um.</li>
            </ul>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>